﻿using System;
using System.Collections.Generic;
using Demo.Linq;

namespace LINQDemo
{
    class Program91
    {
        /// <summary>
        /// .NET 3.0 - anonymous types and local type inference
        /// pattern - when the class is only a container
        /// </summary>
        /// <param name="args"></param>
        static void Main(string[] args)
        {
            IEnumerable<Person> tmpResults =
                Enumerable.Where(Person.GetPersons(),                           
                                //new MyFunc<Person, bool>(Helper.MyPredicate)
                                p => p.Age > 30
                                );

            var results =                                                           // Local type inference
                Enumerable.Select(tmpResults,                                   
                                //new MyFunc<Person, TempType>(Helper.MySelector)
                                p => new { Name = p.Name, Age = p.Age }             // Anonymous type
                                );

            foreach (var p in results)                                              // Local type inference
            {
                //p.
                Console.WriteLine(p.ToString());
            }

            Console.ReadLine();
        }
    }
}
